/* TEMPLATE GENERATED TESTCASE FILE
Filename: CWE563_Unused_Variable__unused_value_struct_01.c
Label Definition File: CWE563_Unused_Variable__unused_value.label.xml
Template File: sources-sinks-01.tmpl.c
*/
/*
 * @description
 * CWE: 563 Unused Variable
 * BadSource:  Initialize data
 * GoodSource: Initialize and use data
 * Sinks:
 *    GoodSink: Use data
 *    BadSink : Initialize and use data
 * Flow Variant: 01 Baseline
 *
 * */

#include "std_testcase.h"

#include <wchar.h>

#ifndef OMITBAD

void CWE563_Unused_Variable__unused_value_struct_01_bad()
{
    twoints data;
    /* POTENTIAL FLAW: Initialize, but do not use data */
    data.a = 0;
    data.b = 0;
    /* POTENTIAL FLAW: Possibly over-write the initial value of data before using it */
    data.a = 1;
    data.b = 1;
    printStructLine(&data);
}

#endif /* OMITBAD */

#ifndef OMITGOOD

/* goodG2B uses the GoodSource with the BadSink */
static void goodG2B()
{
    twoints data;
    /* FIX: Initialize and use data before it is overwritten */
    data.a = 0;
    data.b = 0;
    printStructLine(&data);
    /* POTENTIAL FLAW: Possibly over-write the initial value of data before using it */
    data.a = 1;
    data.b = 1;
    printStructLine(&data);
}

/* goodB2G uses the BadSource with the GoodSink */
static void goodB2G()
{
    twoints data;
    /* POTENTIAL FLAW: Initialize, but do not use data */
    data.a = 0;
    data.b = 0;
    /* FIX: Use data without over-writing its value */
    printStructLine(&data);
}

void CWE563_Unused_Variable__unused_value_struct_01_good()
{
    goodG2B();
    goodB2G();
}

#endif /* OMITGOOD */

/* Below is the main(). It is only used when building this testcase on
   its own for testing or for building a binary to use in testing binary
   analysis tools. It is not used when compiling all the testcases as one
   application, which is how source code analysis tools are tested. */

#ifdef INCLUDEMAIN

int main(int argc, char * argv[])
{
    /* seed randomness */
    srand( (unsigned)time(NULL) );
#ifndef OMITGOOD
    printLine("Calling good()...");
    CWE563_Unused_Variable__unused_value_struct_01_good();
    printLine("Finished good()");
#endif /* OMITGOOD */
#ifndef OMITBAD
    printLine("Calling bad()...");
    CWE563_Unused_Variable__unused_value_struct_01_bad();
    printLine("Finished bad()");
#endif /* OMITBAD */
    return 0;
}

#endif
